/*
 * Decompiled with CFR 0.152.
 */
package emulator.cbm.basic;

import emulator.hardware.memory.MemoryBlockInterface;
import emulator.util.ByteHelper;
import java.util.LinkedList;
import java.util.Queue;

public class BasicHelper {
    static final int BASIC_START_ADDRESS = 43;
    static final int BASIC_END_ADDRESS = 45;
    static final int KEY_BUFFER_IDX_ADDRESS = 198;
    static final int KEY_BUFFER_START_ADDRESS = 631;
    static final int KEY_BUFFER_END_ADDRESS = 640;
    private static MemoryBlockInterface memory_block;
    private static BasicHelper instance;
    private KeyStuffer stuffer_instance = null;

    static {
        instance = new BasicHelper();
    }

    public static void setMemoryBlock(MemoryBlockInterface memory_block) {
        BasicHelper.memory_block = memory_block;
    }

    private static byte[] getMemory() {
        return memory_block.getData();
    }

    private static BasicHelper getInstance() {
        return instance;
    }

    public static void relinkProgram() {
        byte[] memory = BasicHelper.getMemory();
        int i_ptr = BasicHelper.getBasicStart();
        if (i_ptr > 0) {
            memory[i_ptr - 1] = 0;
            while (memory[i_ptr + 1] != 0) {
                int i = 5;
                while (memory[i_ptr + i] != 0 && i < 128) {
                    ++i;
                }
                if (i > 127) {
                    BasicHelper.write_word(memory, i_ptr, 0);
                    break;
                }
                BasicHelper.write_word(memory, i_ptr, i_ptr + ++i);
                i_ptr += i;
            }
            BasicHelper.write_word(memory, 45, i_ptr + 2);
        }
    }

    public static void enterText(String text) {
        if (text.length() > 0) {
            byte[] keys = new byte[text.length()];
            int i = 0;
            while (i < text.length()) {
                keys[i] = BasicHelper.translateChar((byte)text.charAt(i));
                ++i;
            }
            BasicHelper.getInstance().getKeyStufferInstance().putKeys(keys);
        }
    }

    public static void clearText() {
        BasicHelper.getInstance().getKeyStufferInstance().clearBuffer();
    }

    private static byte translateChar(byte ch) {
        return ch == 10 ? (byte)13 : (byte)ch;
    }

    private static void write_word(byte[] memory, int address, int word) {
        memory[address] = (byte)(word & 0xFF);
        memory[address + 1] = (byte)(word >> 8 & 0xFF);
    }

    private static int read_word(byte[] memory, int address) {
        return ByteHelper.byteToInt(memory[address]) + (ByteHelper.byteToInt(memory[address + 1]) << 8);
    }

    KeyStuffer getKeyStufferInstance() {
        if (this.stuffer_instance == null) {
            this.stuffer_instance = new KeyStuffer();
            this.stuffer_instance.start();
        }
        return this.stuffer_instance;
    }

    public static int getBasicStart() {
        return BasicHelper.read_word(BasicHelper.getMemory(), 43);
    }

    public static int getBasicEnd() {
        return BasicHelper.read_word(BasicHelper.getMemory(), 45);
    }

    private class KeyStuffer
    extends Thread {
        private Queue<Byte> key_buffer = new LinkedList<Byte>();

        private KeyStuffer() {
        }

        public synchronized void putKeys(byte[] keys) {
            byte[] byArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                byte key = byArray[n2];
                this.key_buffer.add(key);
                ++n2;
            }
            this.notify();
        }

        public synchronized void clearBuffer() {
            this.key_buffer.clear();
            this.notify();
        }

        @Override
        public synchronized void run() {
            block2: while (true) {
                try {
                    while (this.key_buffer.isEmpty()) {
                        this.wait();
                    }
                    while (true) {
                        if (this.key_buffer.isEmpty()) continue block2;
                        byte[] memory = memory_block.getData();
                        while (memory[198] > 0 && !this.key_buffer.isEmpty()) {
                            this.wait(50L);
                        }
                        if (this.key_buffer.isEmpty()) continue;
                        this.stuffKeys();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void stuffKeys() {
            byte[] memory = BasicHelper.getMemory();
            byte buffer_size = 10;
            byte key_buffer_idx = memory[198];
            while (key_buffer_idx < buffer_size && !this.key_buffer.isEmpty()) {
                memory[631 + key_buffer_idx] = this.key_buffer.remove();
                key_buffer_idx = (byte)(key_buffer_idx + 1);
            }
            memory[198] = key_buffer_idx;
        }
    }
}

